
\ProvidesClass{jdoc}[2023/03/26 par R. Garcia]
 \typeout{-------------------------------------------------------}
 \typeout{Classe JDOC 2023}
 \typeout{-------------------------------------------------------}

\LoadClass[a4paper]{article}

\newif\if@english
\@englishfalse
\DeclareOption{english}{\@englishtrue}
\ProcessOptions\relax


\RequirePackage[utf8]{inputenc}
\RequirePackage{array}
\RequirePackage{booktabs}
\RequirePackage{geometry}
\if@english
	\let\nothing\empty
\else
	\RequirePackage[french]{babel}
\fi

\geometry{
	left=2cm,
	right=2cm,
	top=2.5cm,
	bottom=2.5cm
}







\renewcommand{\fnum@figure}{\small{Fig.~\thefigure}}
\renewcommand{\fnum@table}{\small{Tab.~\thetable}}



\renewcommand{\abstract}[1]{\noindent\textbf{Résumé~:} #1 \\}
\newcommand{\keywords}[1]{\textbf{Mots clés~:} {\itshape #1} \\}
\newcommand{\collab}[1]{\textbf{Collaborations~:} #1 \\}
\if@english
	\renewcommand{\abstract}[1]{\noindent\textbf{Abstract:} #1 \\}
	\renewcommand{\keywords}[1]{\textbf{Keywords:} {\itshape #1} \\}
	\renewcommand{\collab}[1]{\textbf{Collaborations:} #1 \\}
\fi





\AtEndOfClass{
\typeout{-------------------------------------------------------}
 \typeout{Classe JDOC 2023}
 \typeout{-------------------------------------------------------}
 }

\newcommand{\doctoralschool}[1]{{\gdef\@doctoralschool{#1}}}
\newcommand{\doctoralschoolshort}[1]{{\gdef\@doctoralschoolshort{#1}}}
\newcommand{\team}[1]{{\gdef\@team{#1}}}
\newcommand{\email}[1]{{\gdef\@email{#1}}}
\newcommand{\specialty}[1]{{\gdef\@specialty{#1}}}
\newcommand{\institute}[1]{\gdef\@institute{#1}}
\newcommand{\laboratory}[1]{{\gdef\@laboratory{#1}}}

\renewcommand\@maketitle{%
	\newpage
	\thispagestyle{empty}
	\null
	\begin{center}%
		\aboverulesep=0ex
		\belowrulesep=0ex
		\begin{tabular}{|m{0.47\linewidth}|m{0.47\linewidth}|}
			\toprule
			\@institute & \if@english\textbf{Specialty: }\else\textbf{Spécialité~: }\fi \@specialty \\ 
			\if@english {Doctoral School} \else {Ecole Doctorale} \fi \@doctoralschoolshort & \if@english\textbf{Laboratory: }\else\textbf{Laboratoire~: }\fi \@laboratory \\
			\@doctoralschool & \if@english\textbf{Team: }\else\textbf{{\'{E}}quipe~: }\fi \@team \\
			\bottomrule
		\end{tabular}
	
		\vskip 2em
		
		{\LARGE	\@title \par}%
		\vskip 1em%
		{\large \@author}
		\vskip 0.2em
		{\small\@email}
	\end{center}
}
